/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715.demo1;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of device.
 */
public interface Device extends Augmentable  {

    /**
     * Identify the leaf of Device.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents reqStartDateTime.
         */
        REQSTARTDATETIME(1),
        /**
         * Represents reqEndDateTime.
         */
        REQENDDATETIME(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute reqStartDateTime.
     *
     * @return reqStartDateTime value of reqStartDateTime
     */
    String reqStartDateTime();

    /**
     * Returns the attribute reqEndDateTime.
     *
     * @return reqEndDateTime value of reqEndDateTime
     */
    String reqEndDateTime();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute device.
     *
     * @return device list of device
     */
    List<org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device> device();

    /**
     * Sets the attribute reqStartDateTime.
     *
     * @param reqStartDateTime value of reqStartDateTime
     */
    void reqStartDateTime(String reqStartDateTime);

    /**
     * Sets the attribute reqEndDateTime.
     *
     * @param reqEndDateTime value of reqEndDateTime
     */
    void reqEndDateTime(String reqEndDateTime);

    /**
     * Sets the attribute device.
     *
     * @param device list of device
     */
    void device(List<org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device> device);

    /**
     * Adds to the list of device.
     *
     * @param addTo value of device
     */
    void addToDevice(org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.Device addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}