/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.device.Cont7;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.device.GeneralSupervisor;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.device.MaterialSupervisor;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.device.PurchasingSupervisor;
import org.onosproject.yang.gen.v1.demo1.rev20130715.demo1.device.device.Supervisor;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of device.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDevice extends InnerModelObject 
        implements Device, MultiInstanceObject<DeviceKeys> {
    protected String deviceid;
    protected boolean customsSupervisor;
    protected String merchandiserSupervisor;
    protected String tradingSupervisor;
    protected List<String> warehouseSupervisor;
    protected List<String> employeeId;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<MaterialSupervisor> materialSupervisor;
    protected List<GeneralSupervisor> generalSupervisor;
    protected List<Supervisor> supervisor;
    protected PurchasingSupervisor purchasingSupervisor;
    protected Cont7 cont7;

    @Override
    public String deviceid() {
        return deviceid;
    }

    @Override
    public boolean customsSupervisor() {
        return customsSupervisor;
    }

    @Override
    public String merchandiserSupervisor() {
        return merchandiserSupervisor;
    }

    @Override
    public String tradingSupervisor() {
        return tradingSupervisor;
    }

    @Override
    public List<String> warehouseSupervisor() {
        return warehouseSupervisor;
    }

    @Override
    public List<String> employeeId() {
        return employeeId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<MaterialSupervisor> materialSupervisor() {
        return materialSupervisor;
    }

    @Override
    public List<GeneralSupervisor> generalSupervisor() {
        return generalSupervisor;
    }

    @Override
    public List<Supervisor> supervisor() {
        return supervisor;
    }

    @Override
    public PurchasingSupervisor purchasingSupervisor() {
        return purchasingSupervisor;
    }

    @Override
    public Cont7 cont7() {
        return cont7;
    }

    @Override
    public void deviceid(String deviceid) {
        valueLeafFlags.set(LeafIdentifier.DEVICEID.getLeafIndex());
        this.deviceid = deviceid;
    }

    @Override
    public void customsSupervisor(boolean customsSupervisor) {
        valueLeafFlags.set(LeafIdentifier.CUSTOMSSUPERVISOR.getLeafIndex());
        this.customsSupervisor = customsSupervisor;
    }

    @Override
    public void merchandiserSupervisor(String merchandiserSupervisor) {
        valueLeafFlags.set(LeafIdentifier.MERCHANDISERSUPERVISOR.getLeafIndex());
        this.merchandiserSupervisor = merchandiserSupervisor;
    }

    @Override
    public void tradingSupervisor(String tradingSupervisor) {
        valueLeafFlags.set(LeafIdentifier.TRADINGSUPERVISOR.getLeafIndex());
        this.tradingSupervisor = tradingSupervisor;
    }

    @Override
    public void warehouseSupervisor(List<String> warehouseSupervisor) {
        valueLeafFlags.set(LeafIdentifier.WAREHOUSESUPERVISOR.getLeafIndex());
        this.warehouseSupervisor = warehouseSupervisor;
    }

    @Override
    public void employeeId(List<String> employeeId) {
        valueLeafFlags.set(LeafIdentifier.EMPLOYEEID.getLeafIndex());
        this.employeeId = employeeId;
    }

    @Override
    public void materialSupervisor(List<MaterialSupervisor> materialSupervisor) {
        this.materialSupervisor = materialSupervisor;
    }

    @Override
    public void generalSupervisor(List<GeneralSupervisor> generalSupervisor) {
        this.generalSupervisor = generalSupervisor;
    }

    @Override
    public void supervisor(List<Supervisor> supervisor) {
        this.supervisor = supervisor;
    }

    @Override
    public void purchasingSupervisor(PurchasingSupervisor purchasingSupervisor) {
        this.purchasingSupervisor = purchasingSupervisor;
    }

    @Override
    public void cont7(Cont7 cont7) {
        this.cont7 = cont7;
    }

    @Override
    public void addToWarehouseSupervisor(String addTo) {
        if (warehouseSupervisor == null) {
            warehouseSupervisor = new ArrayList<>();
        }
        warehouseSupervisor.add(addTo);
    }


    @Override
    public void addToEmployeeId(String addTo) {
        if (employeeId == null) {
            employeeId = new ArrayList<>();
        }
        employeeId.add(addTo);
    }


    @Override
    public void addToMaterialSupervisor(MaterialSupervisor addTo) {
        if (materialSupervisor == null) {
            materialSupervisor = new ArrayList<>();
        }
        materialSupervisor.add(addTo);
    }


    @Override
    public void addToGeneralSupervisor(GeneralSupervisor addTo) {
        if (generalSupervisor == null) {
            generalSupervisor = new ArrayList<>();
        }
        generalSupervisor.add(addTo);
    }


    @Override
    public void addToSupervisor(Supervisor addTo) {
        if (supervisor == null) {
            supervisor = new ArrayList<>();
        }
        supervisor.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(deviceid, customsSupervisor, merchandiserSupervisor, tradingSupervisor, warehouseSupervisor, employeeId, valueLeafFlags, materialSupervisor, generalSupervisor, supervisor, purchasingSupervisor, cont7);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDevice) {
            DefaultDevice other = (DefaultDevice) obj;
            return
                Objects.deepEquals(deviceid, other.deviceid) &&
                Objects.deepEquals(customsSupervisor, other.customsSupervisor) &&
                Objects.deepEquals(merchandiserSupervisor, other.merchandiserSupervisor) &&
                Objects.deepEquals(tradingSupervisor, other.tradingSupervisor) &&
                Objects.deepEquals(warehouseSupervisor, other.warehouseSupervisor) &&
                Objects.deepEquals(employeeId, other.employeeId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(materialSupervisor, other.materialSupervisor) &&
                Objects.deepEquals(generalSupervisor, other.generalSupervisor) &&
                Objects.deepEquals(supervisor, other.supervisor) &&
                Objects.deepEquals(purchasingSupervisor, other.purchasingSupervisor) &&
                Objects.deepEquals(cont7, other.cont7);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("deviceid=" + deviceid)
            .add("customsSupervisor=" + customsSupervisor)
            .add("merchandiserSupervisor=" + merchandiserSupervisor)
            .add("tradingSupervisor=" + tradingSupervisor)
            .add("warehouseSupervisor=" + warehouseSupervisor)
            .add("employeeId=" + employeeId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("materialSupervisor=" + materialSupervisor)
            .add("generalSupervisor=" + generalSupervisor)
            .add("supervisor=" + supervisor)
            .add("purchasingSupervisor=" + purchasingSupervisor)
            .add("cont7=" + cont7)
            .toString();
    }


    /**
     * Creates an instance of defaultDevice.
     */
    public DefaultDevice() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}