/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import org.dom4j.Element;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.helperutils.HelperContext;
import org.onosproject.yang.runtime.helperutils.SerializerHelper;
import org.onosproject.yang.serializers.utils.SerializersUtil;
import org.onosproject.yang.serializers.xml.XmlListener;
import org.onosproject.yang.serializers.xml.XmlNodeType;

class XmlSerializerListener
implements XmlListener {
    private DataNode.Builder dnBuilder;
    private CompositeData.Builder cBuilder;

    XmlSerializerListener() {
    }

    void dnBuilder(DataNode.Builder builder) {
        this.dnBuilder = builder;
    }

    DataNode.Builder dnBuilder() {
        return this.dnBuilder;
    }

    public CompositeData.Builder cBuilder() {
        return this.cBuilder;
    }

    public void cBuilder(CompositeData.Builder cBuilder) {
        this.cBuilder = cBuilder;
    }

    @Override
    public void enterXmlElement(Element element, XmlNodeType nodeType, Element rootElement) {
        if (element.equals(rootElement)) {
            return;
        }
        if (nodeType == XmlNodeType.OBJECT_NODE && element.content() == null || element.content().isEmpty()) {
            nodeType = XmlNodeType.TEXT_NODE;
        }
        if (nodeType == XmlNodeType.OBJECT_NODE) {
            if (this.dnBuilder != null) {
                this.dnBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dnBuilder, (String)element.getName(), (String)element.getNamespace().getURI(), null, null);
            }
        } else if (nodeType == XmlNodeType.TEXT_NODE && this.dnBuilder != null) {
            this.dnBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dnBuilder, (String)element.getName(), (String)element.getNamespace().getURI(), (String)element.getText(), null);
        }
    }

    @Override
    public void exitXmlElement(Element element, XmlNodeType nodeType, Element rootElement) {
        HelperContext info;
        if (element.equals(rootElement)) {
            return;
        }
        ResourceId id = SerializerHelper.getResourceId((DataNode.Builder)this.dnBuilder);
        AnnotatedNodeInfo annotatedNodeInfo = SerializersUtil.convertXmlAttributesToAnnotations((Element)element, (ResourceId)id);
        if (annotatedNodeInfo != null) {
            this.cBuilder.addAnnotatedNodeInfo(annotatedNodeInfo);
        }
        if ((info = (HelperContext)this.dnBuilder.appInfo()).getParentResourceIdBldr() == null) {
            this.dnBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dnBuilder);
        }
    }
}

