/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.teterminationpointaugment;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeTpId;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.teterminationpointaugment.te.Config;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.teterminationpointaugment.te.State;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of te.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTe extends InnerModelObject implements Te {
    protected TeTpId teTpId;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;

    @Override
    public TeTpId teTpId() {
        return teTpId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public void teTpId(TeTpId teTpId) {
        valueLeafFlags.set(LeafIdentifier.TETPID.getLeafIndex());
        this.teTpId = teTpId;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(teTpId, valueLeafFlags, config, state);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTe) {
            DefaultTe other = (DefaultTe) obj;
            return
                Objects.equals(teTpId, other.teTpId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(config, other.config) &&
                Objects.equals(state, other.state);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("teTpId=" + teTpId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("config=" + config)
            .add("state=" + state)
            .toString();
    }


    /**
     * Creates an instance of defaultTe.
     */
    public DefaultTe() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}