/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

import java.util.Base64;
import java.util.Objects;

/**
 * Represents the implementation of adminGroup.
 */
public final class AdminGroup {

    private byte[] binary;

    /**
     * Creates an instance of adminGroup.
     */
    private AdminGroup() {
    }

    /**
     * Creates an instance of binary.
     *
     * @param binary value of binary
     */
    public AdminGroup(byte[] binary) {
        this.binary = binary;
    }

    /**
     * Returns the object of adminGroup for type binary.
     *
     * @param value value of adminGroup for type binary
     * @return adminGroup for type binary
     */
    public static AdminGroup of(byte[] value) {
        return new AdminGroup(value);
    }

    /**
     * Returns the attribute binary.
     *
     * @return binary value of binary
     */
    public byte[] binary() {
        return binary;
    }
    /**
     * Sets the attribute binary.
     *
     * @param binary value of binary
     */
    public void binary(byte[] binary) {
        this.binary = binary;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binary);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AdminGroup) {
            AdminGroup other = (AdminGroup) obj;
            return
                Objects.equals(binary, other.binary);
        }
        return false;
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(binary).toString();
    }
    /**
     * Returns the object of adminGroup fromString input String adminGroup.
     *
     * @param valInString value of input String
     * @return adminGroup
     */
    public static AdminGroup fromString(String valInString) {
        try {
            byte[] tmpVal = Base64.getDecoder().decode(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
