/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.Style;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of tunnelPathAffinities.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTunnelPathAffinities extends InnerModelObject implements TunnelPathAffinities {
    protected Style style;

    @Override
    public Style style() {
        return style;
    }

    @Override
    public void style(Style style) {
        this.style = style;
    }

    @Override
    public int hashCode() {
        return Objects.hash(style);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnelPathAffinities) {
            DefaultTunnelPathAffinities other = (DefaultTunnelPathAffinities) obj;
            return
                Objects.equals(style, other.style);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("style=" + style)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnelPathAffinities.
     */
    public DefaultTunnelPathAffinities() {
    }

}