/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.sportsarena.bear;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.sportsarena.Bear;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of type.
 */
public interface Type extends Bear, Augmentable  {

    /**
     * Identify the leaf of Type.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents kingfisher.
         */
        KINGFISHER(1),
        /**
         * Represents redbull.
         */
        REDBULL(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute kingfisher.
     *
     * @return kingfisher value of kingfisher
     */
    boolean kingfisher();

    /**
     * Returns the attribute redbull.
     *
     * @return redbull value of redbull
     */
    boolean redbull();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute kingfisher.
     *
     * @param kingfisher value of kingfisher
     */
    void kingfisher(boolean kingfisher);

    /**
     * Sets the attribute redbull.
     *
     * @param redbull value of redbull
     */
    void redbull(boolean redbull);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}