/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetpid.TeTpIdUnion;
import java.util.Objects;

/**
 * Represents the implementation of teTpId.
 */
public final class TeTpId {

    private TeTpIdUnion union;

    /**
     * Creates an instance of teTpId.
     */
    private TeTpId() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public TeTpId(TeTpIdUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of teTpId for type union.
     *
     * @param value value of teTpId for type union
     * @return teTpId for type union
     */
    public static TeTpId of(TeTpIdUnion value) {
        return new TeTpId(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public TeTpIdUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(TeTpIdUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeTpId) {
            TeTpId other = (TeTpId) obj;
            return
                Objects.equals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of teTpId fromString input String teTpId.
     *
     * @param valInString value of input String
     * @return teTpId
     */
    public static TeTpId fromString(String valInString) {
        try {
            TeTpIdUnion tmpVal = TeTpIdUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
