/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of bidirProvisioningDoubleSided.
 */
public abstract class BidirProvisioningDoubleSided extends BidirProvisioningMode {

    /**
     * Returns the attribute bidir-provisioning-double-sided.
     *
     * @return bidir-provisioning-double-sided value of bidir-provisioning-double-sided
     */
    public static String bidirProvisioningDoubleSidedToString() {
        return "bidir-provisioning-double-sided";
    }

    /**
     * Returns the object of bidirProvisioningDoubleSided fromString input String bidirProvisioningDoubleSided.
     *
     * @param valInString value of input String
     * @return bidirProvisioningDoubleSided
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bidir-provisioning-double-sided")) {
            return BidirProvisioningDoubleSided.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}