/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.animal.rev20160624.animal;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.animal.rev20160624.animal.animal.C3;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of animal.
 */
public interface Animal extends Augmentable  {

    /**
     * Identify the leaf of Animal.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents p7.
         */
        P7(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute p7.
     *
     * @return p7 value of p7
     */
    String p7();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute c3.
     *
     * @return c3 value of c3
     */
    C3 c3();

    /**
     * Sets the attribute p7.
     *
     * @param p7 value of p7
     */
    void p7(String p7);

    /**
     * Sets the attribute c3.
     *
     * @param c3 value of c3
     */
    void c3(C3 c3);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}