/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.choicecase.rev20160624;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.choicecase.rev20160624.choicecase.Snack;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of choiceCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class ChoiceCaseOpParam extends InnerModelObject implements ChoiceCase {
    protected Snack snack;

    @Override
    public Snack snack() {
        return snack;
    }

    @Override
    public void snack(Snack snack) {
        this.snack = snack;
    }

    @Override
    public int hashCode() {
        return Objects.hash(snack);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChoiceCaseOpParam) {
            ChoiceCaseOpParam other = (ChoiceCaseOpParam) obj;
            return
                Objects.equals(snack, other.snack);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("snack=" + snack)
            .toString();
    }

    /**
     * Creates an instance of choiceCaseOpParam.
     */
    public ChoiceCaseOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}