/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.host.HostUnion;
import java.util.Objects;

/**
 * Represents the implementation of host.
 */
public final class Host {

    private HostUnion union;

    /**
     * Creates an instance of host.
     */
    private Host() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Host(HostUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of host for type union.
     *
     * @param value value of host for type union
     * @return host for type union
     */
    public static Host of(HostUnion value) {
        return new Host(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public HostUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(HostUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Host) {
            Host other = (Host) obj;
            return
                Objects.equals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of host fromString input String host.
     *
     * @param valInString value of input String
     * @return host
     */
    public static Host fromString(String valInString) {
        try {
            HostUnion tmpVal = HostUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
