/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.performancemetricnormality.PerformanceMetricNormalityEnum;
import java.util.Objects;

/**
 * Represents the implementation of performanceMetricNormality.
 */
public final class PerformanceMetricNormality {

    private PerformanceMetricNormalityEnum enumeration;

    /**
     * Creates an instance of performanceMetricNormality.
     */
    private PerformanceMetricNormality() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public PerformanceMetricNormality(PerformanceMetricNormalityEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of performanceMetricNormality for type enumeration.
     *
     * @param value value of performanceMetricNormality for type enumeration
     * @return performanceMetricNormality for type enumeration
     */
    public static PerformanceMetricNormality of(PerformanceMetricNormalityEnum value) {
        return new PerformanceMetricNormality(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public PerformanceMetricNormalityEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(PerformanceMetricNormalityEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PerformanceMetricNormality) {
            PerformanceMetricNormality other = (PerformanceMetricNormality) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of performanceMetricNormality fromString input String performanceMetricNormality.
     *
     * @param valInString value of input String
     * @return performanceMetricNormality
     */
    public static PerformanceMetricNormality fromString(String valInString) {
        try {
            PerformanceMetricNormalityEnum tmpVal = PerformanceMetricNormalityEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
