/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconfigattributesnotification.TeNodeAttributes;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodestatederivednotification.AltInformationSources;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologytype.TeTopology;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of teNodeEvent.
 */
public interface TeNodeEvent extends Augmentable  {

    /**
     * Identify the leaf of TeNodeEvent.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents eventType.
         */
        EVENTTYPE(1),
        /**
         * Represents nodeRef.
         */
        NODEREF(2),
        /**
         * Represents networkRef.
         */
        NETWORKREF(3),
        /**
         * Represents operStatus.
         */
        OPERSTATUS(4),
        /**
         * Represents isMultiAccessDr.
         */
        ISMULTIACCESSDR(5),
        /**
         * Represents informationSource.
         */
        INFORMATIONSOURCE(6);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute eventType.
     *
     * @return eventType value of eventType
     */
    TeTopologyEventType eventType();

    /**
     * Returns the attribute nodeRef.
     *
     * @return nodeRef value of nodeRef
     */
    Object nodeRef();

    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    Object networkRef();

    /**
     * Returns the attribute operStatus.
     *
     * @return operStatus value of operStatus
     */
    TeOperStatus operStatus();

    /**
     * Returns the attribute isMultiAccessDr.
     *
     * @return isMultiAccessDr value of isMultiAccessDr
     */
    boolean isMultiAccessDr();

    /**
     * Returns the attribute informationSource.
     *
     * @return informationSource value of informationSource
     */
    InformationSourceEnum informationSource();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute teTopology.
     *
     * @return teTopology value of teTopology
     */
    TeTopology teTopology();

    /**
     * Returns the attribute teNodeAttributes.
     *
     * @return teNodeAttributes value of teNodeAttributes
     */
    TeNodeAttributes teNodeAttributes();

    /**
     * Returns the attribute altInformationSources.
     *
     * @return altInformationSources list of altInformationSources
     */
    List<AltInformationSources> altInformationSources();

    /**
     * Returns the attribute informationSourceState.
     *
     * @return informationSourceState value of informationSourceState
     */
    InformationSourceState informationSourceState();

    /**
     * Sets the attribute eventType.
     *
     * @param eventType value of eventType
     */
    void eventType(TeTopologyEventType eventType);

    /**
     * Sets the attribute nodeRef.
     *
     * @param nodeRef value of nodeRef
     */
    void nodeRef(Object nodeRef);

    /**
     * Sets the attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    void networkRef(Object networkRef);

    /**
     * Sets the attribute operStatus.
     *
     * @param operStatus value of operStatus
     */
    void operStatus(TeOperStatus operStatus);

    /**
     * Sets the attribute isMultiAccessDr.
     *
     * @param isMultiAccessDr value of isMultiAccessDr
     */
    void isMultiAccessDr(boolean isMultiAccessDr);

    /**
     * Sets the attribute informationSource.
     *
     * @param informationSource value of informationSource
     */
    void informationSource(InformationSourceEnum informationSource);

    /**
     * Sets the attribute teTopology.
     *
     * @param teTopology value of teTopology
     */
    void teTopology(TeTopology teTopology);

    /**
     * Sets the attribute teNodeAttributes.
     *
     * @param teNodeAttributes value of teNodeAttributes
     */
    void teNodeAttributes(TeNodeAttributes teNodeAttributes);

    /**
     * Sets the attribute altInformationSources.
     *
     * @param altInformationSources list of altInformationSources
     */
    void altInformationSources(List<AltInformationSources> altInformationSources);

    /**
     * Sets the attribute informationSourceState.
     *
     * @param informationSourceState value of informationSourceState
     */
    void informationSourceState(InformationSourceState informationSourceState);

    /**
     * Adds to the list of altInformationSources.
     *
     * @param addTo value of altInformationSources
     */
    void addToAltInformationSources(AltInformationSources addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}