/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of underlay.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultUnderlay extends InnerModelObject implements Underlay {
    protected boolean dynamic;
    protected boolean committed;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean dynamic() {
        return dynamic;
    }

    @Override
    public boolean committed() {
        return committed;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void dynamic(boolean dynamic) {
        valueLeafFlags.set(LeafIdentifier.DYNAMIC.getLeafIndex());
        this.dynamic = dynamic;
    }

    @Override
    public void committed(boolean committed) {
        valueLeafFlags.set(LeafIdentifier.COMMITTED.getLeafIndex());
        this.committed = committed;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dynamic, committed, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultUnderlay) {
            DefaultUnderlay other = (DefaultUnderlay) obj;
            return
                Objects.equals(dynamic, other.dynamic) &&
                Objects.equals(committed, other.committed) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("dynamic=" + dynamic)
            .add("committed=" + committed)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultUnderlay.
     */
    public DefaultUnderlay() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}