/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of lspProt1Forn.
 */
public abstract class LspProt1Forn {

    /**
     * Returns the attribute lsp-prot-1-for-n.
     *
     * @return lsp-prot-1-for-n value of lsp-prot-1-for-n
     */
    public static String lspProt1FornToString() {
        return "lsp-prot-1-for-n";
    }

    /**
     * Returns the object of lspProt1Forn fromString input String lspProt1Forn.
     *
     * @param valInString value of input String
     * @return lspProt1Forn
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("lsp-prot-1-for-n")) {
            return LspProt1Forn.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}