/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathselection;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.PathMetricType;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.PathTiebreakerType;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.TopologyId;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.TunnelPathAffinities;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathsrlgs.TunnelPathSrlgs;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of pathSelection.
 */
public interface PathSelection extends Augmentable  {

    /**
     * Identify the leaf of PathSelection.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents topology.
         */
        TOPOLOGY(1),
        /**
         * Represents costLimit.
         */
        COSTLIMIT(2),
        /**
         * Represents hopLimit.
         */
        HOPLIMIT(3),
        /**
         * Represents metricType.
         */
        METRICTYPE(4),
        /**
         * Represents tiebreakerType.
         */
        TIEBREAKERTYPE(5),
        /**
         * Represents ignoreOverload.
         */
        IGNOREOVERLOAD(6);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute topology.
     *
     * @return topology value of topology
     */
    TopologyId topology();

    /**
     * Returns the attribute costLimit.
     *
     * @return costLimit value of costLimit
     */
    long costLimit();

    /**
     * Returns the attribute hopLimit.
     *
     * @return hopLimit value of hopLimit
     */
    short hopLimit();

    /**
     * Returns the attribute metricType.
     *
     * @return metricType value of metricType
     */
    Class<? extends PathMetricType> metricType();

    /**
     * Returns the attribute tiebreakerType.
     *
     * @return tiebreakerType value of tiebreakerType
     */
    Class<? extends PathTiebreakerType> tiebreakerType();

    /**
     * Returns the attribute ignoreOverload.
     *
     * @return ignoreOverload value of ignoreOverload
     */
    boolean ignoreOverload();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute tunnelPathAffinities.
     *
     * @return tunnelPathAffinities value of tunnelPathAffinities
     */
    TunnelPathAffinities tunnelPathAffinities();

    /**
     * Returns the attribute tunnelPathSrlgs.
     *
     * @return tunnelPathSrlgs value of tunnelPathSrlgs
     */
    TunnelPathSrlgs tunnelPathSrlgs();

    /**
     * Sets the attribute topology.
     *
     * @param topology value of topology
     */
    void topology(TopologyId topology);

    /**
     * Sets the attribute costLimit.
     *
     * @param costLimit value of costLimit
     */
    void costLimit(long costLimit);

    /**
     * Sets the attribute hopLimit.
     *
     * @param hopLimit value of hopLimit
     */
    void hopLimit(short hopLimit);

    /**
     * Sets the attribute metricType.
     *
     * @param metricType value of metricType
     */
    void metricType(Class<? extends PathMetricType> metricType);

    /**
     * Sets the attribute tiebreakerType.
     *
     * @param tiebreakerType value of tiebreakerType
     */
    void tiebreakerType(Class<? extends PathTiebreakerType> tiebreakerType);

    /**
     * Sets the attribute ignoreOverload.
     *
     * @param ignoreOverload value of ignoreOverload
     */
    void ignoreOverload(boolean ignoreOverload);

    /**
     * Sets the attribute tunnelPathAffinities.
     *
     * @param tunnelPathAffinities value of tunnelPathAffinities
     */
    void tunnelPathAffinities(TunnelPathAffinities tunnelPathAffinities);

    /**
     * Sets the attribute tunnelPathSrlgs.
     *
     * @param tunnelPathSrlgs value of tunnelPathSrlgs
     */
    void tunnelPathSrlgs(TunnelPathSrlgs tunnelPathSrlgs);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}