/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of zeroBasedCounter64.
 */
public final class ZeroBasedCounter64 {

    private Counter64 counter64;

    /**
     * Creates an instance of zeroBasedCounter64.
     */
    private ZeroBasedCounter64() {
    }

    /**
     * Creates an instance of counter64.
     *
     * @param counter64 value of counter64
     */
    public ZeroBasedCounter64(Counter64 counter64) {
        this.counter64 = counter64;
    }

    /**
     * Returns the object of zeroBasedCounter64 for type counter64.
     *
     * @param value value of zeroBasedCounter64 for type counter64
     * @return zeroBasedCounter64 for type counter64
     */
    public static ZeroBasedCounter64 of(Counter64 value) {
        return new ZeroBasedCounter64(value);
    }

    /**
     * Returns the attribute counter64.
     *
     * @return counter64 value of counter64
     */
    public Counter64 counter64() {
        return counter64;
    }
    /**
     * Sets the attribute counter64.
     *
     * @param counter64 value of counter64
     */
    public void counter64(Counter64 counter64) {
        this.counter64 = counter64;
    }

    @Override
    public int hashCode() {
        return Objects.hash(counter64);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZeroBasedCounter64) {
            ZeroBasedCounter64 other = (ZeroBasedCounter64) obj;
            return
                Objects.equals(counter64, other.counter64);
        }
        return false;
    }

    @Override
    public String toString() {
        return counter64.toString();
    }
    /**
     * Returns the object of zeroBasedCounter64 fromString input String zeroBasedCounter64.
     *
     * @param valInString value of input String
     * @return zeroBasedCounter64
     */
    public static ZeroBasedCounter64 fromString(String valInString) {
        try {
            Counter64 tmpVal = Counter64.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
