/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.util.Stack;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.onosproject.yang.model.DataNode;

public abstract class XmlSerializerHandler {
    Element processXmlContext(DataNode dataNode, Stack<Element> elementStack) {
        Element newElement = this.updateNameAndNamespace(dataNode, elementStack);
        return newElement;
    }

    Element updateNameAndNamespace(DataNode node, Stack<Element> elementStack) {
        String nameSpace = null;
        String name = null;
        if (node.key() != null && node.key().schemaId() != null) {
            nameSpace = node.key().schemaId().namespace();
            name = node.key().schemaId().name();
        }
        if (elementStack.isEmpty()) {
            Element rootElement = DocumentHelper.createDocument().addElement(name);
            if (nameSpace != null) {
                rootElement.add(Namespace.get((String)nameSpace));
            }
            return rootElement;
        }
        Element xmlElement = elementStack.peek();
        Element newElement = nameSpace != null ? xmlElement.addElement(name, nameSpace) : xmlElement.addElement(name);
        return newElement;
    }

    public void setXmlValue(DataNode dataNode, Stack<Element> domElementStack) {
    }
}

