/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.animal.rev20160624;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.animal.rev20160624.animal.C2;
import org.onosproject.yang.gen.v1.animal.rev20160624.animal.C4;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of animal.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class AnimalOpParam extends InnerModelObject implements Animal {
    protected boolean bool;
    protected List<Boolean> yangAutoPrefixBoolean;
    protected BitSet valueLeafFlags = new BitSet();
    protected org.onosproject.yang.gen.v1.animal.rev20160624.animal.Animal animal;
    protected C4 c4;
    protected C2 c2;

    @Override
    public boolean bool() {
        return bool;
    }

    @Override
    public List<Boolean> yangAutoPrefixBoolean() {
        return yangAutoPrefixBoolean;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public org.onosproject.yang.gen.v1.animal.rev20160624.animal.Animal animal() {
        return animal;
    }

    @Override
    public C4 c4() {
        return c4;
    }

    @Override
    public C2 c2() {
        return c2;
    }

    @Override
    public void bool(boolean bool) {
        valueLeafFlags.set(LeafIdentifier.BOOL.getLeafIndex());
        this.bool = bool;
    }

    @Override
    public void yangAutoPrefixBoolean(List<Boolean> yangAutoPrefixBoolean) {
        valueLeafFlags.set(LeafIdentifier.YANGAUTOPREFIXBOOLEAN.getLeafIndex());
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    @Override
    public void animal(org.onosproject.yang.gen.v1.animal.rev20160624.animal.Animal animal) {
        this.animal = animal;
    }

    @Override
    public void c4(C4 c4) {
        this.c4 = c4;
    }

    @Override
    public void c2(C2 c2) {
        this.c2 = c2;
    }

    @Override
    public void addToYangAutoPrefixBoolean(Boolean addTo) {
        if (yangAutoPrefixBoolean == null) {
            yangAutoPrefixBoolean = new ArrayList<>();
        }
        yangAutoPrefixBoolean.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(bool, yangAutoPrefixBoolean, valueLeafFlags, animal, c4, c2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnimalOpParam) {
            AnimalOpParam other = (AnimalOpParam) obj;
            return
                Objects.deepEquals(bool, other.bool) &&
                Objects.deepEquals(yangAutoPrefixBoolean, other.yangAutoPrefixBoolean) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(animal, other.animal) &&
                Objects.deepEquals(c4, other.c4) &&
                Objects.deepEquals(c2, other.c2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("bool=" + bool)
            .add("yangAutoPrefixBoolean=" + yangAutoPrefixBoolean)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("animal=" + animal)
            .add("c4=" + c4)
            .add("c2=" + c2)
            .toString();
    }

    /**
     * Creates an instance of animalOpParam.
     */
    public AnimalOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}