/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.animal.rev20160624.animal;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.animal.rev20160624.animal.animal.C3;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of animal.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAnimal extends InnerModelObject implements Animal {
    protected String p7;
    protected BitSet valueLeafFlags = new BitSet();
    protected C3 c3;

    @Override
    public String p7() {
        return p7;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public C3 c3() {
        return c3;
    }

    @Override
    public void p7(String p7) {
        valueLeafFlags.set(LeafIdentifier.P7.getLeafIndex());
        this.p7 = p7;
    }

    @Override
    public void c3(C3 c3) {
        this.c3 = c3;
    }

    @Override
    public int hashCode() {
        return Objects.hash(p7, valueLeafFlags, c3);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAnimal) {
            DefaultAnimal other = (DefaultAnimal) obj;
            return
                Objects.deepEquals(p7, other.p7) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(c3, other.c3);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("p7=" + p7)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("c3=" + c3)
            .toString();
    }


    /**
     * Creates an instance of defaultAnimal.
     */
    public DefaultAnimal() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}