/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.sportsarena.bear;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.sportsarena.Bear;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of type.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultType extends InnerModelObject implements Type {
    protected boolean kingfisher;
    protected boolean redbull;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean kingfisher() {
        return kingfisher;
    }

    @Override
    public boolean redbull() {
        return redbull;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void kingfisher(boolean kingfisher) {
        valueLeafFlags.set(LeafIdentifier.KINGFISHER.getLeafIndex());
        this.kingfisher = kingfisher;
    }

    @Override
    public void redbull(boolean redbull) {
        valueLeafFlags.set(LeafIdentifier.REDBULL.getLeafIndex());
        this.redbull = redbull;
    }

    @Override
    public int hashCode() {
        return Objects.hash(kingfisher, redbull, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultType) {
            DefaultType other = (DefaultType) obj;
            return
                Objects.deepEquals(kingfisher, other.kingfisher) &&
                Objects.deepEquals(redbull, other.redbull) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("kingfisher=" + kingfisher)
            .add("redbull=" + redbull)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultType.
     */
    public DefaultType() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}