/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.logisticsmanager.rev20160524;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.logisticsmanager.rev20160524.logisticsmanager.MaterialSupervisor;
import org.onosproject.yang.gen.v1.logisticsmanager.rev20160524.logisticsmanager.PurchasingSupervisor;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of logisticsManager.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class LogisticsManagerOpParam extends InnerModelObject implements LogisticsManager {
    protected String customsSupervisor;
    protected String merchandiserSupervisor;
    protected String tradingSupervisor;
    protected List<String> warehouseSupervisor;
    protected List<String> employeeId;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<MaterialSupervisor> materialSupervisor;
    protected PurchasingSupervisor purchasingSupervisor;

    @Override
    public String customsSupervisor() {
        return customsSupervisor;
    }

    @Override
    public String merchandiserSupervisor() {
        return merchandiserSupervisor;
    }

    @Override
    public String tradingSupervisor() {
        return tradingSupervisor;
    }

    @Override
    public List<String> warehouseSupervisor() {
        return warehouseSupervisor;
    }

    @Override
    public List<String> employeeId() {
        return employeeId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<MaterialSupervisor> materialSupervisor() {
        return materialSupervisor;
    }

    @Override
    public PurchasingSupervisor purchasingSupervisor() {
        return purchasingSupervisor;
    }

    @Override
    public void customsSupervisor(String customsSupervisor) {
        valueLeafFlags.set(LeafIdentifier.CUSTOMSSUPERVISOR.getLeafIndex());
        this.customsSupervisor = customsSupervisor;
    }

    @Override
    public void merchandiserSupervisor(String merchandiserSupervisor) {
        valueLeafFlags.set(LeafIdentifier.MERCHANDISERSUPERVISOR.getLeafIndex());
        this.merchandiserSupervisor = merchandiserSupervisor;
    }

    @Override
    public void tradingSupervisor(String tradingSupervisor) {
        valueLeafFlags.set(LeafIdentifier.TRADINGSUPERVISOR.getLeafIndex());
        this.tradingSupervisor = tradingSupervisor;
    }

    @Override
    public void warehouseSupervisor(List<String> warehouseSupervisor) {
        valueLeafFlags.set(LeafIdentifier.WAREHOUSESUPERVISOR.getLeafIndex());
        this.warehouseSupervisor = warehouseSupervisor;
    }

    @Override
    public void employeeId(List<String> employeeId) {
        valueLeafFlags.set(LeafIdentifier.EMPLOYEEID.getLeafIndex());
        this.employeeId = employeeId;
    }

    @Override
    public void materialSupervisor(List<MaterialSupervisor> materialSupervisor) {
        this.materialSupervisor = materialSupervisor;
    }

    @Override
    public void purchasingSupervisor(PurchasingSupervisor purchasingSupervisor) {
        this.purchasingSupervisor = purchasingSupervisor;
    }

    @Override
    public void addToWarehouseSupervisor(String addTo) {
        if (warehouseSupervisor == null) {
            warehouseSupervisor = new ArrayList<>();
        }
        warehouseSupervisor.add(addTo);
    }


    @Override
    public void addToEmployeeId(String addTo) {
        if (employeeId == null) {
            employeeId = new ArrayList<>();
        }
        employeeId.add(addTo);
    }


    @Override
    public void addToMaterialSupervisor(MaterialSupervisor addTo) {
        if (materialSupervisor == null) {
            materialSupervisor = new ArrayList<>();
        }
        materialSupervisor.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(customsSupervisor, merchandiserSupervisor, tradingSupervisor, warehouseSupervisor, employeeId, valueLeafFlags, materialSupervisor, purchasingSupervisor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogisticsManagerOpParam) {
            LogisticsManagerOpParam other = (LogisticsManagerOpParam) obj;
            return
                Objects.deepEquals(customsSupervisor, other.customsSupervisor) &&
                Objects.deepEquals(merchandiserSupervisor, other.merchandiserSupervisor) &&
                Objects.deepEquals(tradingSupervisor, other.tradingSupervisor) &&
                Objects.deepEquals(warehouseSupervisor, other.warehouseSupervisor) &&
                Objects.deepEquals(employeeId, other.employeeId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(materialSupervisor, other.materialSupervisor) &&
                Objects.deepEquals(purchasingSupervisor, other.purchasingSupervisor);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("customsSupervisor=" + customsSupervisor)
            .add("merchandiserSupervisor=" + merchandiserSupervisor)
            .add("tradingSupervisor=" + tradingSupervisor)
            .add("warehouseSupervisor=" + warehouseSupervisor)
            .add("employeeId=" + employeeId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("materialSupervisor=" + materialSupervisor)
            .add("purchasingSupervisor=" + purchasingSupervisor)
            .toString();
    }

    /**
     * Creates an instance of logisticsManagerOpParam.
     */
    public LogisticsManagerOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}