/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624.yangautoprefixlist.c2;

import java.lang.String;
import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of l2.
 */
public class L2Keys implements KeyInfo<DefaultL2> {
    protected String m1;
    protected String m2;
    /**
     * Returns the attribute m1.
     *
     * @return m1 value of m1
     */
    public String m1() {
        return m1;
    }

    /**
     * Sets the value to attribute m1.
     *
     * @param m1 value of m1
     */
    public void m1(String m1) {
        this.m1 = m1;
    }

    /**
     * Returns the attribute m2.
     *
     * @return m2 value of m2
     */
    public String m2() {
        return m2;
    }

    /**
     * Sets the value to attribute m2.
     *
     * @param m2 value of m2
     */
    public void m2(String m2) {
        this.m2 = m2;
    }


    @Override
    public int hashCode() {
        return Objects.hash(m1, m2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof L2Keys) {
            L2Keys other = (L2Keys) obj;
            return
                Objects.deepEquals(m1, other.m1) &&
                Objects.deepEquals(m2, other.m2);
        }
        return false;
    }
}