/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks.network.NetworkTypes;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks.network.Node;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks.network.SupportingNetwork;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of network.
 */
public interface Network extends Augmentable  {

    /**
     * Identify the leaf of Network.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents networkId.
         */
        NETWORKID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute networkId.
     *
     * @return networkId value of networkId
     */
    NetworkId networkId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute networkTypes.
     *
     * @return networkTypes value of networkTypes
     */
    NetworkTypes networkTypes();

    /**
     * Returns the attribute supportingNetwork.
     *
     * @return supportingNetwork list of supportingNetwork
     */
    List<SupportingNetwork> supportingNetwork();

    /**
     * Returns the attribute node.
     *
     * @return node list of node
     */
    List<Node> node();

    /**
     * Sets the attribute networkId.
     *
     * @param networkId value of networkId
     */
    void networkId(NetworkId networkId);

    /**
     * Sets the attribute networkTypes.
     *
     * @param networkTypes value of networkTypes
     */
    void networkTypes(NetworkTypes networkTypes);

    /**
     * Sets the attribute supportingNetwork.
     *
     * @param supportingNetwork list of supportingNetwork
     */
    void supportingNetwork(List<SupportingNetwork> supportingNetwork);

    /**
     * Sets the attribute node.
     *
     * @param node list of node
     */
    void node(List<Node> node);

    /**
     * Adds to the list of supportingNetwork.
     *
     * @param addTo value of supportingNetwork
     */
    void addToSupportingNetwork(SupportingNetwork addTo);

    /**
     * Adds to the list of node.
     *
     * @param addTo value of node
     */
    void addToNode(Node addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}