/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfigattributes.telinkattributes;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.UnderlayBackupPath;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.UnderlayPrimaryPath;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.UnderlayTrailDes;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.UnderlayTrailSrc;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of underlay.
 */
public interface Underlay extends Augmentable  {

    /**
     * Identify the leaf of Underlay.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents underlayProtectionType.
         */
        UNDERLAYPROTECTIONTYPE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute underlayProtectionType.
     *
     * @return underlayProtectionType value of underlayProtectionType
     */
    int underlayProtectionType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute underlayPrimaryPath.
     *
     * @return underlayPrimaryPath value of underlayPrimaryPath
     */
    UnderlayPrimaryPath underlayPrimaryPath();

    /**
     * Returns the attribute underlayBackupPath.
     *
     * @return underlayBackupPath list of underlayBackupPath
     */
    List<UnderlayBackupPath> underlayBackupPath();

    /**
     * Returns the attribute underlayTrailSrc.
     *
     * @return underlayTrailSrc value of underlayTrailSrc
     */
    UnderlayTrailSrc underlayTrailSrc();

    /**
     * Returns the attribute underlayTrailDes.
     *
     * @return underlayTrailDes value of underlayTrailDes
     */
    UnderlayTrailDes underlayTrailDes();

    /**
     * Sets the attribute underlayProtectionType.
     *
     * @param underlayProtectionType value of underlayProtectionType
     */
    void underlayProtectionType(int underlayProtectionType);

    /**
     * Sets the attribute underlayPrimaryPath.
     *
     * @param underlayPrimaryPath value of underlayPrimaryPath
     */
    void underlayPrimaryPath(UnderlayPrimaryPath underlayPrimaryPath);

    /**
     * Sets the attribute underlayBackupPath.
     *
     * @param underlayBackupPath list of underlayBackupPath
     */
    void underlayBackupPath(List<UnderlayBackupPath> underlayBackupPath);

    /**
     * Sets the attribute underlayTrailSrc.
     *
     * @param underlayTrailSrc value of underlayTrailSrc
     */
    void underlayTrailSrc(UnderlayTrailSrc underlayTrailSrc);

    /**
     * Sets the attribute underlayTrailDes.
     *
     * @param underlayTrailDes value of underlayTrailDes
     */
    void underlayTrailDes(UnderlayTrailDes underlayTrailDes);

    /**
     * Adds to the list of underlayBackupPath.
     *
     * @param addTo value of underlayBackupPath
     */
    void addToUnderlayBackupPath(UnderlayBackupPath addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}