/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of resourceAffIncludeAny.
 */
public abstract class ResourceAffIncludeAny extends ResourceAffinitiesType {

    /**
     * Returns the attribute resource-aff-include-any.
     *
     * @return resource-aff-include-any value of resource-aff-include-any
     */
    public static String resourceAffIncludeAnyToString() {
        return "resource-aff-include-any";
    }

    /**
     * Returns the object of resourceAffIncludeAny fromString input String resourceAffIncludeAny.
     *
     * @param valInString value of input String
     * @return resourceAffIncludeAny
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("resource-aff-include-any")) {
            return ResourceAffIncludeAny.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}