/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.type;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipv4Address.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv4Address extends InnerModelObject implements Ipv4Address {
    protected org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address v4Address;
    protected short v4PrefixLength;
    protected boolean v4Loose;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address v4Address() {
        return v4Address;
    }

    @Override
    public short v4PrefixLength() {
        return v4PrefixLength;
    }

    @Override
    public boolean v4Loose() {
        return v4Loose;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void v4Address(org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address v4Address) {
        valueLeafFlags.set(LeafIdentifier.V4ADDRESS.getLeafIndex());
        this.v4Address = v4Address;
    }

    @Override
    public void v4PrefixLength(short v4PrefixLength) {
        valueLeafFlags.set(LeafIdentifier.V4PREFIXLENGTH.getLeafIndex());
        this.v4PrefixLength = v4PrefixLength;
    }

    @Override
    public void v4Loose(boolean v4Loose) {
        valueLeafFlags.set(LeafIdentifier.V4LOOSE.getLeafIndex());
        this.v4Loose = v4Loose;
    }

    @Override
    public int hashCode() {
        return Objects.hash(v4Address, v4PrefixLength, v4Loose, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv4Address) {
            DefaultIpv4Address other = (DefaultIpv4Address) obj;
            return
                Objects.deepEquals(v4Address, other.v4Address) &&
                Objects.deepEquals(v4PrefixLength, other.v4PrefixLength) &&
                Objects.deepEquals(v4Loose, other.v4Loose) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("v4Address=" + v4Address)
            .add("v4PrefixLength=" + v4PrefixLength)
            .add("v4Loose=" + v4Loose)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv4Address.
     */
    public DefaultIpv4Address() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}