/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelbidirassocproperties;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelbidirassocproperties.bidirectional.Association;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of bidirectional.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultBidirectional extends InnerModelObject implements Bidirectional {
    protected Association association;

    @Override
    public Association association() {
        return association;
    }

    @Override
    public void association(Association association) {
        this.association = association;
    }

    @Override
    public int hashCode() {
        return Objects.hash(association);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBidirectional) {
            DefaultBidirectional other = (DefaultBidirectional) obj;
            return
                Objects.deepEquals(association, other.association);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("association=" + association)
            .toString();
    }


    /**
     * Creates an instance of defaultBidirectional.
     */
    public DefaultBidirectional() {
    }

}