/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style.named;

import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.ResourceAffinitiesType;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of constraints.
 */
public class ConstraintsKeys implements KeyInfo<DefaultConstraints> {
    protected Class<? extends ResourceAffinitiesType> usage;
    /**
     * Returns the attribute usage.
     *
     * @return usage value of usage
     */
    public Class<? extends ResourceAffinitiesType> usage() {
        return usage;
    }

    /**
     * Sets the value to attribute usage.
     *
     * @param usage value of usage
     */
    public void usage(Class<? extends ResourceAffinitiesType> usage) {
        this.usage = usage;
    }


    @Override
    public int hashCode() {
        return Objects.hash(usage);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstraintsKeys) {
            ConstraintsKeys other = (ConstraintsKeys) obj;
            return
                Objects.deepEquals(usage, other.usage);
        }
        return false;
    }
}