/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.food.rev20160624.food;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.food.rev20160624.food.food.Snack;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of food.
 */
public interface Food extends Augmentable  {

    /**
     * Identify the leaf of Food.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents p1.
         */
        P1(1),
        /**
         * Represents p2.
         */
        P2(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute p1.
     *
     * @return p1 value of p1
     */
    boolean p1();

    /**
     * Returns the attribute p2.
     *
     * @return p2 list of p2
     */
    List<String> p2();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute snack.
     *
     * @return snack value of snack
     */
    Snack snack();

    /**
     * Sets the attribute p1.
     *
     * @param p1 value of p1
     */
    void p1(boolean p1);

    /**
     * Sets the attribute p2.
     *
     * @param p2 list of p2
     */
    void p2(List<String> p2);

    /**
     * Sets the attribute snack.
     *
     * @param snack value of snack
     */
    void snack(Snack snack);

    /**
     * Adds to the list of p2.
     *
     * @param addTo value of p2
     */
    void addToP2(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}