/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624.yangautoprefixlist;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624.yangautoprefixlist.c2.L2;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of c2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultC2 extends InnerModelObject implements C2 {
    protected List<L2> l2;

    @Override
    public List<L2> l2() {
        return l2;
    }

    @Override
    public void l2(List<L2> l2) {
        this.l2 = l2;
    }

    @Override
    public void addToL2(L2 addTo) {
        if (l2 == null) {
            l2 = new ArrayList<>();
        }
        l2.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(l2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultC2) {
            DefaultC2 other = (DefaultC2) obj;
            return
                Objects.equals(l2, other.l2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("l2=" + l2)
            .toString();
    }


    /**
     * Creates an instance of defaultC2.
     */
    public DefaultC2() {
    }

}