/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Uri;
import java.util.Objects;

/**
 * Represents the implementation of nodeId.
 */
public final class NodeId {

    private Uri uri;

    /**
     * Creates an instance of nodeId.
     */
    private NodeId() {
    }

    /**
     * Creates an instance of uri.
     *
     * @param uri value of uri
     */
    public NodeId(Uri uri) {
        this.uri = uri;
    }

    /**
     * Returns the object of nodeId for type uri.
     *
     * @param value value of nodeId for type uri
     * @return nodeId for type uri
     */
    public static NodeId of(Uri value) {
        return new NodeId(value);
    }

    /**
     * Returns the attribute uri.
     *
     * @return uri value of uri
     */
    public Uri uri() {
        return uri;
    }
    /**
     * Sets the attribute uri.
     *
     * @param uri value of uri
     */
    public void uri(Uri uri) {
        this.uri = uri;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uri);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeId) {
            NodeId other = (NodeId) obj;
            return
                Objects.equals(uri, other.uri);
        }
        return false;
    }

    @Override
    public String toString() {
        return uri.toString();
    }
    /**
     * Returns the object of nodeId fromString input String nodeId.
     *
     * @param valInString value of input String
     * @return nodeId
     */
    public static NodeId fromString(String valInString) {
        try {
            Uri tmpVal = Uri.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
