/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologyeventtype.TeTopologyEventTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of teTopologyEventType.
 */
public final class TeTopologyEventType {

    private TeTopologyEventTypeEnum enumeration;

    /**
     * Creates an instance of teTopologyEventType.
     */
    private TeTopologyEventType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeTopologyEventType(TeTopologyEventTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teTopologyEventType for type enumeration.
     *
     * @param value value of teTopologyEventType for type enumeration
     * @return teTopologyEventType for type enumeration
     */
    public static TeTopologyEventType of(TeTopologyEventTypeEnum value) {
        return new TeTopologyEventType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeTopologyEventTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeTopologyEventTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeTopologyEventType) {
            TeTopologyEventType other = (TeTopologyEventType) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teTopologyEventType fromString input String teTopologyEventType.
     *
     * @param valInString value of input String
     * @return teTopologyEventType
     */
    public static TeTopologyEventType fromString(String valInString) {
        try {
            TeTopologyEventTypeEnum tmpVal = TeTopologyEventTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
