/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.component.componentlinks.ComponentLink;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of componentLinks.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultComponentLinks extends InnerModelObject implements ComponentLinks {
    protected List<ComponentLink> componentLink;

    @Override
    public List<ComponentLink> componentLink() {
        return componentLink;
    }

    @Override
    public void componentLink(List<ComponentLink> componentLink) {
        this.componentLink = componentLink;
    }

    @Override
    public void addToComponentLink(ComponentLink addTo) {
        if (componentLink == null) {
            componentLink = new ArrayList<>();
        }
        componentLink.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(componentLink);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultComponentLinks) {
            DefaultComponentLinks other = (DefaultComponentLinks) obj;
            return
                Objects.equals(componentLink, other.componentLink);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("componentLink=" + componentLink)
            .toString();
    }


    /**
     * Creates an instance of defaultComponentLinks.
     */
    public DefaultComponentLinks() {
    }

}