/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of underlayBackupPath.
 */
public class UnderlayBackupPathKeys implements KeyInfo<DefaultUnderlayBackupPath> {
    protected long index;
    /**
     * Returns the attribute index.
     *
     * @return index value of index
     */
    public long index() {
        return index;
    }

    /**
     * Sets the value to attribute index.
     *
     * @param index value of index
     */
    public void index(long index) {
        this.index = index;
    }


    @Override
    public int hashCode() {
        return Objects.hash(index);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnderlayBackupPathKeys) {
            UnderlayBackupPathKeys other = (UnderlayBackupPathKeys) obj;
            return
                Objects.equals(index, other.index);
        }
        return false;
    }
}