/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode.tpoint;

import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.TpId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of supportingTerminationPoint.
 */
public class SupportingTerminationPointKeys implements KeyInfo<DefaultSupportingTerminationPoint> {
    protected NetworkId networkRef;
    protected NodeId nodeRef;
    protected TpId tpRef;
    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    public NetworkId networkRef() {
        return networkRef;
    }

    /**
     * Sets the value to attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    public void networkRef(NetworkId networkRef) {
        this.networkRef = networkRef;
    }

    /**
     * Returns the attribute nodeRef.
     *
     * @return nodeRef value of nodeRef
     */
    public NodeId nodeRef() {
        return nodeRef;
    }

    /**
     * Sets the value to attribute nodeRef.
     *
     * @param nodeRef value of nodeRef
     */
    public void nodeRef(NodeId nodeRef) {
        this.nodeRef = nodeRef;
    }

    /**
     * Returns the attribute tpRef.
     *
     * @return tpRef value of tpRef
     */
    public TpId tpRef() {
        return tpRef;
    }

    /**
     * Sets the value to attribute tpRef.
     *
     * @param tpRef value of tpRef
     */
    public void tpRef(TpId tpRef) {
        this.tpRef = tpRef;
    }


    @Override
    public int hashCode() {
        return Objects.hash(networkRef, nodeRef, tpRef);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SupportingTerminationPointKeys) {
            SupportingTerminationPointKeys other = (SupportingTerminationPointKeys) obj;
            return
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(nodeRef, other.nodeRef) &&
                Objects.equals(tpRef, other.tpRef);
        }
        return false;
    }
}