/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.util.HashMap;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.serializers.xml.XmlSerializerException;
import org.onosproject.yang.serializers.xml.XmlSerializerHandler;
import org.onosproject.yang.serializers.xml.XmlSerializerLeafHandler;
import org.onosproject.yang.serializers.xml.XmlSerializerNodeHandler;

public final class SerializerHandlerFactory {
    private final Map<DataNode.Type, XmlSerializerHandler> handlerMap = new HashMap<DataNode.Type, XmlSerializerHandler>();

    private SerializerHandlerFactory() {
        this.handlerMap.put(DataNode.Type.SINGLE_INSTANCE_NODE, new XmlSerializerNodeHandler());
        this.handlerMap.put(DataNode.Type.MULTI_INSTANCE_NODE, new XmlSerializerNodeHandler());
        this.handlerMap.put(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE, new XmlSerializerLeafHandler());
        this.handlerMap.put(DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE, new XmlSerializerLeafHandler());
    }

    public XmlSerializerHandler getSerializerHandlerForContext(DataNode node) {
        XmlSerializerHandler handler = this.handlerMap.get(node.type());
        if (handler == null) {
            throw new XmlSerializerException("Unsupported node type " + node.type());
        }
        return handler;
    }

    public static SerializerHandlerFactory instance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        private static final SerializerHandlerFactory INSTANCE = new SerializerHandlerFactory();

        private LazyHolder() {
        }
    }
}

