/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelbidirassocproperties.bidirectional;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.BidirAssociationType;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.BidirProvisioningMode;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of association.
 */
public interface Association extends Augmentable  {

    /**
     * Identify the leaf of Association.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents source.
         */
        SOURCE(2),
        /**
         * Represents globalSource.
         */
        GLOBALSOURCE(3),
        /**
         * Represents type.
         */
        TYPE(4),
        /**
         * Represents provisioing.
         */
        PROVISIOING(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    int id();

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    IpAddress source();

    /**
     * Returns the attribute globalSource.
     *
     * @return globalSource value of globalSource
     */
    IpAddress globalSource();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends BidirAssociationType> type();

    /**
     * Returns the attribute provisioing.
     *
     * @return provisioing value of provisioing
     */
    Class<? extends BidirProvisioningMode> provisioing();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(int id);

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(IpAddress source);

    /**
     * Sets the attribute globalSource.
     *
     * @param globalSource value of globalSource
     */
    void globalSource(IpAddress globalSource);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends BidirAssociationType> type);

    /**
     * Sets the attribute provisioing.
     *
     * @param provisioing value of provisioing
     */
    void provisioing(Class<? extends BidirProvisioningMode> provisioing);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}