/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.TpId;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode.tpoint.SupportingTerminationPoint;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of tPoint.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTpoint extends InnerModelObject 
        implements Tpoint, MultiInstanceObject<TpointKeys> {
    protected TpId tpId;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<SupportingTerminationPoint> supportingTerminationPoint;

    @Override
    public TpId tpId() {
        return tpId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<SupportingTerminationPoint> supportingTerminationPoint() {
        return supportingTerminationPoint;
    }

    @Override
    public void tpId(TpId tpId) {
        valueLeafFlags.set(LeafIdentifier.TPID.getLeafIndex());
        this.tpId = tpId;
    }

    @Override
    public void supportingTerminationPoint(List<SupportingTerminationPoint> supportingTerminationPoint) {
        this.supportingTerminationPoint = supportingTerminationPoint;
    }

    @Override
    public void addToSupportingTerminationPoint(SupportingTerminationPoint addTo) {
        if (supportingTerminationPoint == null) {
            supportingTerminationPoint = new ArrayList<>();
        }
        supportingTerminationPoint.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tpId, valueLeafFlags, supportingTerminationPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTpoint) {
            DefaultTpoint other = (DefaultTpoint) obj;
            return
                Objects.deepEquals(tpId, other.tpId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(supportingTerminationPoint, other.supportingTerminationPoint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tpId=" + tpId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("supportingTerminationPoint=" + supportingTerminationPoint)
            .toString();
    }


    /**
     * Creates an instance of defaultTpoint.
     */
    public DefaultTpoint() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}