/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.util.Iterator;
import org.dom4j.Element;
import org.onosproject.yang.serializers.xml.XmlListener;
import org.onosproject.yang.serializers.xml.XmlNodeType;
import org.onosproject.yang.serializers.xml.XmlSerializerException;
import org.onosproject.yang.serializers.xml.XmlWalker;

public class DefaultXmlWalker
implements XmlWalker {
    @Override
    public void walk(XmlListener listener, Element element, Element rootElement) {
        try {
            listener.enterXmlElement(element, this.getElementType(element), rootElement);
            if (element.hasContent() && !element.isTextOnly()) {
                Iterator i = element.elementIterator();
                while (i.hasNext()) {
                    Element childElement = (Element)i.next();
                    this.walk(listener, childElement, rootElement);
                }
            }
            listener.exitXmlElement(element, this.getElementType(element), rootElement);
        }
        catch (Exception e) {
            throw new XmlSerializerException(e.getMessage());
        }
    }

    private XmlNodeType getElementType(Element element) {
        Element newElement = element.createCopy();
        newElement.remove(element.getNamespace());
        return newElement.hasContent() && newElement.isTextOnly() ? XmlNodeType.TEXT_NODE : XmlNodeType.OBJECT_NODE;
    }
}

