/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.Interfaces;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.IntType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of con1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCon1 extends InnerModelObject implements Con1 {
    protected Class<? extends IntType> yangAutoPrefixInterface;
    protected BitSet valueLeafFlags = new BitSet();
    protected Interfaces interfaces;

    @Override
    public Class<? extends IntType> yangAutoPrefixInterface() {
        return yangAutoPrefixInterface;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Interfaces interfaces() {
        return interfaces;
    }

    @Override
    public void yangAutoPrefixInterface(Class<? extends IntType> yangAutoPrefixInterface) {
        valueLeafFlags.set(LeafIdentifier.YANGAUTOPREFIXINTERFACE.getLeafIndex());
        this.yangAutoPrefixInterface = yangAutoPrefixInterface;
    }

    @Override
    public void interfaces(Interfaces interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixInterface, valueLeafFlags, interfaces);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCon1) {
            DefaultCon1 other = (DefaultCon1) obj;
            return
                Objects.deepEquals(yangAutoPrefixInterface, other.yangAutoPrefixInterface) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(interfaces, other.interfaces);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixInterface=" + yangAutoPrefixInterface)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("interfaces=" + interfaces)
            .toString();
    }


    /**
     * Creates an instance of defaultCon1.
     */
    public DefaultCon1() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}