/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.attributes.attributes.top;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.attributes.attributes.top.yangautoprefixinterface.Address;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yangAutoPrefixInterface.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYangAutoPrefixInterface extends InnerModelObject implements YangAutoPrefixInterface {
    protected String name;
    protected String mtu;
    protected BitSet valueLeafFlags = new BitSet();
    protected Address address;

    @Override
    public String name() {
        return name;
    }

    @Override
    public String mtu() {
        return mtu;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Address address() {
        return address;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void mtu(String mtu) {
        valueLeafFlags.set(LeafIdentifier.MTU.getLeafIndex());
        this.mtu = mtu;
    }

    @Override
    public void address(Address address) {
        this.address = address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, mtu, valueLeafFlags, address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangAutoPrefixInterface) {
            DefaultYangAutoPrefixInterface other = (DefaultYangAutoPrefixInterface) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(mtu, other.mtu) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(address, other.address);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("mtu=" + mtu)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("address=" + address)
            .toString();
    }


    /**
     * Creates an instance of defaultYangAutoPrefixInterface.
     */
    public DefaultYangAutoPrefixInterface() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}