/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.performancemetric.Measurement;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.performancemetric.Normality;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of performanceMetric.
 */
public interface PerformanceMetric extends Augmentable  {

    /**
     * Returns the attribute measurement.
     *
     * @return measurement value of measurement
     */
    Measurement measurement();

    /**
     * Returns the attribute normality.
     *
     * @return normality value of normality
     */
    Normality normality();

    /**
     * Sets the attribute measurement.
     *
     * @param measurement value of measurement
     */
    void measurement(Measurement measurement);

    /**
     * Sets the attribute normality.
     *
     * @param normality value of normality
     */
    void normality(Normality normality);

}