/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Uri;
import java.util.Objects;

/**
 * Represents the implementation of tpId.
 */
public final class TpId {

    private Uri uri;

    /**
     * Creates an instance of tpId.
     */
    private TpId() {
    }

    /**
     * Creates an instance of uri.
     *
     * @param uri value of uri
     */
    public TpId(Uri uri) {
        this.uri = uri;
    }

    /**
     * Returns the object of tpId for type uri.
     *
     * @param value value of tpId for type uri
     * @return tpId for type uri
     */
    public static TpId of(Uri value) {
        return new TpId(value);
    }

    /**
     * Returns the attribute uri.
     *
     * @return uri value of uri
     */
    public Uri uri() {
        return uri;
    }
    /**
     * Sets the attribute uri.
     *
     * @param uri value of uri
     */
    public void uri(Uri uri) {
        this.uri = uri;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uri);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TpId) {
            TpId other = (TpId) obj;
            return
                Objects.deepEquals(uri, other.uri);
        }
        return false;
    }

    @Override
    public String toString() {
        return uri.toString();
    }
    /**
     * Returns the object of tpId fromString input String tpId.
     *
     * @param valInString value of input String
     * @return tpId
     */
    public static TpId fromString(String valInString) {
        try {
            Uri tmpVal = Uri.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
