/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes;

/**
 * Represents ENUM data of informationSourceEnum.
 */
public enum InformationSourceEnum {

    /**
     * Represents unknown.
     */
    UNKNOWN(0, "unknown"),

    /**
     * Represents locally-configured.
     */
    LOCALLY_CONFIGURED(1, "locally-configured"),

    /**
     * Represents ospfv2.
     */
    OSPFV2(2, "ospfv2"),

    /**
     * Represents ospfv3.
     */
    OSPFV3(3, "ospfv3"),

    /**
     * Represents isis.
     */
    ISIS(4, "isis"),

    /**
     * Represents system-processed.
     */
    SYSTEM_PROCESSED(5, "system-processed"),

    /**
     * Represents other.
     */
    OTHER(6, "other");

    private int informationSourceEnum;
    private String schemaName;

    /**
     * Creates an instance of informationSourceEnum.
     *
     * @param informationSourceEnum value of informationSourceEnum
     */
     InformationSourceEnum(int informationSourceEnum, String schemaName) {
        this.informationSourceEnum = informationSourceEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of informationSourceEnum for.
     *
     * @param value value of informationSourceEnum for
     * @return informationSourceEnum for
     */
    public static InformationSourceEnum of(int value) {
        switch (value) {
            case 0:
                return InformationSourceEnum.UNKNOWN;
            case 1:
                return InformationSourceEnum.LOCALLY_CONFIGURED;
            case 2:
                return InformationSourceEnum.OSPFV2;
            case 3:
                return InformationSourceEnum.OSPFV3;
            case 4:
                return InformationSourceEnum.ISIS;
            case 5:
                return InformationSourceEnum.SYSTEM_PROCESSED;
            case 6:
                return InformationSourceEnum.OTHER;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of informationSourceEnum for.
     *
     * @param value value of informationSourceEnum for
     * @return informationSourceEnum for
     */
    public static InformationSourceEnum of(String value) {
        switch (value) {
            case "unknown":
                return InformationSourceEnum.UNKNOWN;
            case "locally-configured":
                return InformationSourceEnum.LOCALLY_CONFIGURED;
            case "ospfv2":
                return InformationSourceEnum.OSPFV2;
            case "ospfv3":
                return InformationSourceEnum.OSPFV3;
            case "isis":
                return InformationSourceEnum.ISIS;
            case "system-processed":
                return InformationSourceEnum.SYSTEM_PROCESSED;
            case "other":
                return InformationSourceEnum.OTHER;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute informationSourceEnum.
     *
     * @return informationSourceEnum value of informationSourceEnum
     */
    public int informationSourceEnum() {
        return informationSourceEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
