/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of pathComputationSrlgType.
 */
public abstract class PathComputationSrlgType {

    /**
     * Returns the attribute path-computation-srlg-type.
     *
     * @return path-computation-srlg-type value of path-computation-srlg-type
     */
    public static String pathComputationSrlgTypeToString() {
        return "path-computation-srlg-type";
    }

    /**
     * Returns the object of pathComputationSrlgType fromString input String pathComputationSrlgType.
     *
     * @param valInString value of input String
     * @return pathComputationSrlgType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-computation-srlg-type")) {
            return PathComputationSrlgType.class;
        } else if (valInString.equals("srlg-ignore")) {
            return SrlgIgnore.class;
        } else if (valInString.equals("srlg-strict")) {
            return SrlgStrict.class;
        } else if (valInString.equals("srlg-preferred")) {
            return SrlgPreferred.class;
        } else if (valInString.equals("srlg-weighted")) {
            return SrlgWeighted.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}