/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkaccesstype.TeLinkAccessTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of teLinkAccessType.
 */
public final class TeLinkAccessType {

    private TeLinkAccessTypeEnum enumeration;

    /**
     * Creates an instance of teLinkAccessType.
     */
    private TeLinkAccessType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeLinkAccessType(TeLinkAccessTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teLinkAccessType for type enumeration.
     *
     * @param value value of teLinkAccessType for type enumeration
     * @return teLinkAccessType for type enumeration
     */
    public static TeLinkAccessType of(TeLinkAccessTypeEnum value) {
        return new TeLinkAccessType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeLinkAccessTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeLinkAccessTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeLinkAccessType) {
            TeLinkAccessType other = (TeLinkAccessType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teLinkAccessType fromString input String teLinkAccessType.
     *
     * @param valInString value of input String
     * @return teLinkAccessType
     */
    public static TeLinkAccessType fromString(String valInString) {
        try {
            TeLinkAccessTypeEnum tmpVal = TeLinkAccessTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
