/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability.timedivisionmultiplexcapable;

/**
 * Represents ENUM data of indicationEnum.
 */
public enum IndicationEnum {

    /**
     * Represents standard.
     */
    STANDARD(0, "standard"),

    /**
     * Represents arbitrary.
     */
    ARBITRARY(1, "arbitrary");

    private int indicationEnum;
    private String schemaName;

    /**
     * Creates an instance of indicationEnum.
     *
     * @param indicationEnum value of indicationEnum
     */
     IndicationEnum(int indicationEnum, String schemaName) {
        this.indicationEnum = indicationEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of indicationEnum for.
     *
     * @param value value of indicationEnum for
     * @return indicationEnum for
     */
    public static IndicationEnum of(int value) {
        switch (value) {
            case 0:
                return IndicationEnum.STANDARD;
            case 1:
                return IndicationEnum.ARBITRARY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of indicationEnum for.
     *
     * @param value value of indicationEnum for
     * @return indicationEnum for
     */
    public static IndicationEnum of(String value) {
        switch (value) {
            case "standard":
                return IndicationEnum.STANDARD;
            case "arbitrary":
                return IndicationEnum.ARBITRARY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute indicationEnum.
     *
     * @return indicationEnum value of indicationEnum
     */
    public int indicationEnum() {
        return indicationEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
