/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.component;

import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.component.componentlinks.ComponentLink;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of componentLinks.
 */
public interface ComponentLinks extends Augmentable  {

    /**
     * Returns the attribute componentLink.
     *
     * @return componentLink list of componentLink
     */
    List<ComponentLink> componentLink();

    /**
     * Sets the attribute componentLink.
     *
     * @param componentLink list of componentLink
     */
    void componentLink(List<ComponentLink> componentLink);

    /**
     * Adds to the list of componentLink.
     *
     * @param addTo value of componentLink
     */
    void addToComponentLink(ComponentLink addTo);

}